use_script("rotate.lua");
use_script("belt.lua");

function modify_frame(active, orient, overallFrameNum, colormap, lightspecmap)
    vsp_merge(colormap, rotate_sprite(vsp_from_assets("blocksprites/blockBreaker/blockBreakerColormap.vsp"), orient));
    vsp_merge(lightspecmap, rotate_sprite(vsp_from_assets("blocksprites/blockBreaker/blockBreakerLightmap.vsp"), orient));
    
    local remapTable = {};
    remapTable[color_from_rgb(0, 0, 0)] = 0;
    vsp_color_remap(colormap, remapTable);
end

function modify_mask(active, orient, mask)
    local blockBreakerMask = rotate_sprite(vsp_from_assets("blocksprites/blockBreaker/blockBreakerMask.vsp"), orient);
    vsp_merge(mask, blockBreakerMask);

    local remapTable = {};
    remapTable[color_from_rgb(0, 0, 0)] = 0;
    vsp_color_remap(mask, remapTable);
end

export_belt(BELT_DEFAULT_COLOR_MAP, BELT_DEFAULT_ACTIVE_LIGHT_MAP, modify_mask, modify_frame);