for side = 0, 5 do
    local bounds = {};
    bounds[0] = 0;
    bounds[1] = 8;
    bounds[2] = 0;
    bounds[3] = 8;
    bounds[4] = 0;
    bounds[5] = 8;
    bounds[side] = 4;

    local colormap = vsp_clone(SLAB_BASE_COLORMAP);
    vsp_fill_box(colormap, bounds, TRANSPARENT);

    local mask = vsp_clone(SLAB_BASE_COLLISION_MASK);
    vsp_fill_box(mask, bounds, TRANSPARENT);

    local state_name = "filled" .. get_side_name(side);
    export_frame(state_name, {
        colormap = colormap,
        biasmap = SLAB_BASE_BIASMAP,
        refractmap = SLAB_BASE_REFRACTMAP,
        lightspecmap = SLAB_BASE_LIGHTSPECMAP,
    });

    set_collision_mask(state_name, mask);
end

export_frame("full", {
    colormap = SLAB_BASE_COLORMAP,
    biasmap = SLAB_BASE_BIASMAP,
    refractmap = SLAB_BASE_REFRACTMAP,
    lightspecmap = SLAB_BASE_LIGHTSPECMAP,
});

set_collision_mask("full", SLAB_BASE_COLLISION_MASK);