use_script("rotate.lua");
use_script("belt.lua");

function arrange_sprite(path, orient, useSign)
    function mirror_remap(x, y, z)
        return x, 7 - y, z;
    end

    local raw = vsp_from_assets(path);
    if useSign == 1 then
        raw = remap_voxel_positions(raw, mirror_remap);
    end

    return rotate_sprite(raw, orient);
end

for i = 0, 1 do
    local signName = "Neg";
    if i == 1 then
        signName = "Pos";
    end

    function get_state_name(activeFlagName, orient, frameOffset)
        return activeFlagName .. get_side_name(orient) .. frameOffset .. signName;
    end

    function modify_frame(active, orient, overallFrameNum, colormap, lightspecmap)
        -- TODO: For some reason the lightmap of the belt is not applied!!
        vsp_merge(colormap, arrange_sprite("blocksprites/itemDeployer/itemDeployerColormap.vsp", orient, i));
        vsp_merge(lightspecmap, arrange_sprite("blocksprites/itemDeployer/itemDeployerLightmap.vsp", orient, i));
        
        local remapTable = {};
        remapTable[color_from_rgb(0, 0, 0)] = 0;
        vsp_color_remap(colormap, remapTable);
    end
    
    function modify_mask(active, orient, mask)
        local itemDeployerMask = arrange_sprite("blocksprites/itemDeployer/itemDeployerMask.vsp", orient, i);
        vsp_merge(mask, itemDeployerMask);
    
        local remapTable = {};
        remapTable[color_from_rgb(0, 0, 0)] = 0;
        vsp_color_remap(mask, remapTable);
    end
    
    export_belt(BELT_DEFAULT_COLOR_MAP, BELT_DEFAULT_ACTIVE_LIGHT_MAP, modify_mask, modify_frame, get_state_name);
end